// background.js – نسخه نهایی و ۱۰۰٪ بدون ارور (کروم + فایرفاکس)

const tools = [
  { title: "فشرده‌ساز تصویر", url: "https://linkee.ir/tools/optimizer/" },
  { title: "کوتاه‌کننده لینک", url: "https://s.linkee.ir/" },
  { title: "تحلیل سئو داخلی", url: "https://linkee.ir/tools/seo/" },
  { title: "رمزساز امن", url: "https://linkee.ir/tools/password/" },
  { title: "QR کد ساز", url: "https://linkee.ir/tools/qr/" },
  { title: "انتخابگر رنگ و پالت‌ساز", url: "https://linkee.ir/tools/color/" },
  { title: "ادیتور توسعه وب (HTML+CSS+JS)", url: "https://linkee.ir/tools/editor/" },
  { title: "ادیتور پایتون + مستندات", url: "https://linkee.ir/tools/python/" },
  { title: "نوت‌پد فارسی", url: "https://linkee.ir/tools/notepad/" }
];

// ساخت منوی راست‌کلیک (یک بار هنگام نصب یا آپدیت)
function createContextMenu() {
  chrome.contextMenus.removeAll(() => {
    // منوی اصلی
    chrome.contextMenus.create({
      id: "linkee_main",
      title: "Linkee Tools",
      contexts: ["page", "selection", "link", "editable"]
    });

    // خط جداکننده
    chrome.contextMenus.create({
      type: "separator",
      id: "linkee_sep",
      parentId: "linkee_main"
    });

    // ابزارها به عنوان زیرمنو
    tools.forEach((tool, index) => {
      chrome.contextMenus.create({
        id: "linkee_tool_" + index,
        parentId: "linkee_main",
        title: tool.title,
        contexts: ["page", "selection", "link", "editable"]
      });
    });
  });
}

// وقتی کاربر روی یکی از ابزارها کلیک کرد
chrome.contextMenus.onClicked.addListener((info) => {
  if (info.menuItemId && info.menuItemId.startsWith("linkee_tool_")) {
    const index = parseInt(info.menuItemId.replace("linkee_tool_", ""));
    const url = tools[index]?.url;
    if (url) {
      chrome.tabs.create({ url });
    }
  }
});

// اولین بار که افزونه نصب یا آپدیت می‌شه منو ساخته بشه
chrome.runtime.onInstalled.addListener(() => {
  createContextMenu();
});

// اگر مرورگر ری‌استارت شد و منو گم شد، دوباره بساز
chrome.runtime.onStartup?.addListener(createContextMenu);